// public/assets/js/agent.js

document.addEventListener('DOMContentLoaded', () => {
  const saveBtn = document.getElementById('save-agent-btn');
  const agentIdInput = document.getElementById('agent-id');
  const nameInput = document.getElementById('agent-name');
  const descInput = document.getElementById('agent-desc');
  const configInput = document.getElementById('agent-config');
  const feedbackEl = document.getElementById('agent-feedback');

  saveBtn.addEventListener('click', async () => {
    const id = parseInt(agentIdInput.value) || 0;
    const nome = nameInput.value.trim();
    const descricao = descInput.value.trim();
    const config_json = configInput.value.trim();

    if (!nome) {
      feedbackEl.innerHTML = '<div class="alert error">Nome é obrigatório.</div>';
      return;
    }

    let parsed;
    try {
      parsed = JSON.parse(config_json);
    } catch (e) {
      feedbackEl.innerHTML = '<div class="alert error">JSON inválido em configurações.</div>';
      return;
    }

    const payload = {
      id,
      nome,
      descricao,
      config_json: JSON.stringify(parsed)
    };

    try {
      const res = await fetch('/controllers/AgentController.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify(payload)
      });
      const data = await res.json();
      if (!res.ok || data.error) {
        feedbackEl.innerHTML = `<div class="alert error">Erro: ${data.error || 'Não foi possível salvar.'}</div>`;
        return;
      }
      feedbackEl.innerHTML = '<div class="alert success">Agente salvo com sucesso!</div>';
      // Se criou novo agente, atualiza o campo ID
      if (data.agent_id) {
        agentIdInput.value = data.agent_id;
      }
    } catch (err) {
      console.error(err);
      feedbackEl.innerHTML = '<div class="alert error">Ocorreu um erro inesperado.</div>';
    }
  });
});
