<?php
// /chat/delete_conversation.php
require_once __DIR__ . '/config.php';
header('Content-Type: application/json; charset=utf-8');

// Verifica autenticação
if (empty($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'error' => 'Não autorizado']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
if (!is_array($input) || empty($input['conversation_id'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => 'Dados inválidos']);
    exit;
}

$userId = $_SESSION['user_id'];
$convid = (int)$input['conversation_id'];

// Primeiro, remova as mensagens vinculadas (se você estiver usando chave estrangeira CASCADE, pode pular esta etapa).
$stmt1 = $pdo->prepare('DELETE FROM messages WHERE conversation_id = ?');
$stmt1->execute([$convid]);

// Depois, remova a própria conversa
$stmt2 = $pdo->prepare('DELETE FROM conversations WHERE id = ? AND user_id = ?');
$stmt2->execute([$convid, $userId]);

if ($stmt2->rowCount() > 0) {
    echo json_encode(['success' => true]);
} else {
    http_response_code(404);
    echo json_encode(['success' => false, 'error' => 'Conversa não encontrada ou sem permissão']);
}
exit;
