// /chat/public/assets/js/agent_list.js

export default async function agentList() {
  const listEl = document.getElementById('agent-list');
  try {
    const res = await fetch('controllers/AgentController.php');
    const agentes = await res.json();
    listEl.innerHTML = '';

    if (agentes.length === 0) {
      listEl.innerHTML = '<p class="placeholder">Nenhum agente criado ainda.</p>';
      return;
    }

    agentes.forEach(agente => {
      const div = document.createElement('div');
      div.classList.add('chat-item');
      div.innerHTML = `
        <strong>${agente.nome}</strong><br>
        <small>${new Date(agente.updated_at).toLocaleString()}</small>
        <br>
        <a href="agent_form.php?id=${agente.id}" class="btn secondary small">Editar</a>
      `;
      listEl.appendChild(div);
    });
  } catch (err) {
    console.error(err);
    listEl.innerHTML = '<p class="placeholder">Erro ao carregar agentes.</p>';
  }
}
