<?php
// /chat/views/chat_interface.php
// Atenção: o config.php já foi incluído em index.php, antes de chamar este arquivo.
// Portanto, NÃO incluímos config.php aqui novamente.
if (empty($_SESSION['user_id'])) {
    // Caso este arquivo seja chamado isoladamente, redireciona para login
    header('Location: login.php');
    exit;
}
$userId = (int) $_SESSION['user_id'];
?>
<aside class="sidebar">
  <div class="sidebar-header" style="display: flex; flex-direction: column; padding: 1rem; gap: 0.5rem;">
    <!-- Botão “Nova Conversa” -->
    <a
      href="#"
      id="btn-new-conversation"
      class="btn create-chat-link"
      style="display: inline-flex; align-items: center;"
    >
      <span class="icon-plus" style="font-size: 1.25rem; margin-right: 0.25rem;">＋</span>
      <span class="link-text">Nova Conversa</span>
    </a>

    <!-- Accordion “Meus Agentes” -->
    <div
      class="accordion-header"
      id="accordion-header"
      style="
        display: flex;
        align-items: center;
        cursor: pointer;
        user-select: none;
        padding: 0.5rem;
        background-color: var(--sidebar-bg);
        border: 1px solid var(--border);
        border-radius: 4px;
      "
    >
      <span
        class="icon"
        id="accordion-icon"
        style="
          display: inline-block;
          transition: transform 0.2s ease;
          margin-right: 0.5rem;
          font-weight: bold;
        "
      >►</span>
      <span style="color: var(--sidebar-text); font-weight: bold;">Meus Agentes</span>
    </div>
    <div
      class="accordion-content"
      id="accordion-content"
      style="
        display: none;
        margin-top: 0.5rem;
        border: 1px solid var(--border);
        border-radius: 4px;
        background-color: var(--input-background);
        max-height: 200px;
        overflow-y: auto;
      "
    >
      <ul style="list-style: none; padding: 0; margin: 0;">
        <?php
        $stmtAgents = $pdo->prepare('SELECT id, nome FROM agents WHERE user_id = ? ORDER BY nome ASC');
        $stmtAgents->execute([$userId]);
        $agents = $stmtAgents->fetchAll(PDO::FETCH_ASSOC);
        foreach ($agents as $agent) {
            $activeStyle = (isset($_GET['agent_id']) && (int)$_GET['agent_id'] === (int)$agent['id'])
                ? 'background-color: var(--sidebar-bg); font-weight: bold;'
                : '';
            echo '<li>';
            echo '<a href="agent_chat.php?agent_id=' . intval($agent['id']) . '" '
               . 'style="display: block; padding: 0.5rem; color: var(--text-color); text-decoration: none; ' 
               . $activeStyle . '">'
               . htmlspecialchars($agent['nome'], ENT_QUOTES)
               . '</a>';
            echo '</li>';
        }
        ?>
      </ul>
    </div>

    <!-- Botão “+ Criar Agente” -->
    <a
      href="agent_form.php"
      class="btn secondary"
      style="margin-top: 0.5rem; white-space: nowrap;"
    >
      + Criar Agente
    </a>
  </div>

  <div
    class="chat-list"
    id="chat-list"
    style="padding: 0 1rem; overflow-y: auto; flex-grow: 1;"
  >
    <p class="placeholder" style="color: var(--text-tertiary);">
      Nenhuma conversa ainda.
    </p>
  </div>
</aside>

<section class="chat-area">
  <div
    class="chat-header"
    style="
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 1rem;
      border-bottom: 1px solid var(--border);
      background-color: var(--sidebar-bg);
    "
  >
    <div class="chat-header-left">
      <h2 id="current-chat-title" style="margin: 0; color: var(--text-color);">Nova Conversa</h2>
    </div>
    <div class="chat-header-right" style="display: flex; align-items: center; gap: 0.5rem;">
      <label for="model-select" style="margin-right: 0.25rem; color: var(--text-color);">Modelo:</label>
      <select id="model-select" class="model-select">
        <option value="gpt-3.5-turbo" selected>gpt-3.5-turbo</option>
        <option value="gpt-4o">gpt-4o</option>
        <option value="gpt-4-turbo">gpt-4-turbo</option>
      </select>

      <button
        id="rename-chat-btn"
        class="btn secondary"
        title="Renomear Conversa"
        disabled
        style="font-size: 1rem;"
      >
        ✏️
      </button>
      <button
        id="delete-chat-btn"
        class="btn"
        title="Excluir Conversa"
        disabled
        style="font-size: 1rem; background-color: #dc3545; color: #ffffff;"
      >
        🗑️
      </button>
    </div>
  </div>

  <div
    class="chat-messages"
    id="chat-messages"
    style="padding: 1rem; overflow-y: auto; flex-grow: 1; background-color: var(--chat-bg);"
  >
    <p class="placeholder" style="color: var(--text-tertiary);">
      Envie uma mensagem para começar.
    </p>
  </div>

  <div
    class="chat-input-area"
    style="
      display: flex;
      align-items: stretch;
      padding: 1rem;
      border-top: 1px solid var(--border);
      background-color: var(--chat-bg);
    "
  >
    <textarea
      id="chat-input"
      rows="4"
      placeholder="Digite sua mensagem..."
      style="
        flex-grow: 1;
        resize: none;
        padding: 0.5rem;
        border: 1px solid var(--border);
        border-radius: 0.25rem;
        background-color: var(--input-bg);
        color: var(--input-text);
        font-family: inherit;
        font-size: 1rem;
      "
    ></textarea>
    <button
      id="send-btn"
      class="btn btn-primary"
      style="margin-left: 0.5rem; white-space: nowrap;"
    >
      Enviar
    </button>
  </div>
</section>

<!-- Inclua o main.js normalmente -->
<script src="public/assets/js/main.js" type="module"></script>
<!-- Inclua o secondary.js se necessário -->
<script src="public/assets/js/secondary.js" type="module"></script>

<!-- Script que controla o accordion -->
<script>
  const header = document.getElementById('accordion-header');
  const icon   = document.getElementById('accordion-icon');
  const content = document.getElementById('accordion-content');
  if (header && icon && content) {
    header.addEventListener('click', () => {
      const hidden = getComputedStyle(content).display === 'none';
      if (hidden) {
        content.style.display = 'block';
        icon.style.transform = 'rotate(90deg)';
      } else {
        content.style.display = 'none';
        icon.style.transform = 'rotate(0deg)';
      }
    });
  }
</script>
