<?php
$apiKey = isset($_POST['api_key']) ? $_POST['api_key'] : '';
$userMessage = isset($_POST['message']) ? $_POST['message'] : '';
$response = '';

if ($apiKey && $userMessage) {
    $data = [
        "model" => "gpt-3.5-turbo",
        "messages" => [
            ["role" => "user", "content" => $userMessage]
        ]
    ];

    $ch = curl_init("https://api.openai.com/v1/chat/completions");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        "Content-Type: application/json",
        "Authorization: Bearer " . $apiKey
    ]);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    $result = curl_exec($ch);
    curl_close($ch);

    $decoded = json_decode($result, true);
    if (isset($decoded['choices'][0]['message']['content'])) {
        $response = $decoded['choices'][0]['message']['content'];
    } else {
        $response = "Erro na resposta da API.";
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Chat com Sally</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 text-gray-900 min-h-screen flex items-center justify-center p-4">
    <div class="w-full max-w-2xl bg-white rounded-lg shadow p-6 space-y-4">
        <form method="POST" class="space-y-4">
            <input type="text" name="api_key" placeholder="Sua API Key" class="w-full px-4 py-2 border rounded" value="<?php echo htmlspecialchars($apiKey); ?>" required />
            <textarea name="message" placeholder="Digite sua mensagem..." class="w-full px-4 py-2 border rounded resize-none" required><?php echo htmlspecialchars($userMessage); ?></textarea>
            <button type="submit" class="px-6 py-2 bg-blue-600 text-white rounded hover:bg-blue-700">Enviar</button>
        </form>
        <?php if ($response): ?>
        <div class="p-4 bg-gray-50 border-l-4 border-blue-400">
            <strong>Resposta:</strong>
            <p class="mt-2 whitespace-pre-line"><?php echo nl2br(htmlspecialchars($response)); ?></p>
        </div>
        <?php endif; ?>
    </div>
</body>
</html>
